﻿//Call this to register our module to main application
var moduleTemplateName = "testModule2";

if (AppDependencies != undefined) {
    AppDependencies.push(moduleTemplateName);
}

angular.module(moduleTemplateName, [
    'testModule2.blades.blade1'
])
.config(
  ['$stateProvider',
    function ($stateProvider) {
        $stateProvider
            .state('workspace.testModule2', {
            	url: '/testModule2',
            	templateUrl: 'Scripts/common/templates/home.tpl.html',
                controller: [
                    '$scope', 'platformWebApp.bladeNavigationService', function ($scope, bladeNavigationService) {
                        var blade = {
                            id: 'blade1',
                            // controller name must be unique in Application. Use prefix like 'um-'.
                            controller: 'testModule2.blade1Controller',
                            template: 'Modules/$(TestModule2)/Scripts/blades/blade1.tpl.html',
                            isClosingDisabled: true
                        };
                        bladeNavigationService.showBlade(blade);
                    }
                ]
            });
    }
  ]
)
.run(
  ['$rootScope', 'platformWebApp.mainMenuService', '$state', function ($rootScope, mainMenuService, $state) {
      //Register module in main menu
      var menuItem = {
          path: 'browse/testModule2',
          icon: 'fa fa-folder',
          title: 'Test Module 1',
          priority: 110,
          action: function () { $state.go('workspace.testModule2'); },
          permission: 'TestModule2Permission'
      };
      mainMenuService.addMenuItem(menuItem);
  }]);