using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Newtonsoft.Json;



namespace VirtoCommerce.Client.Model
{

    /// <summary>
    /// Class containing associated product information like &#39;Accessory&#39;, &#39;Related Item&#39;, etc.
    /// </summary>
    [DataContract]
    public class VirtoCommerceCatalogModuleWebModelProductAssociation : IEquatable<VirtoCommerceCatalogModuleWebModelProductAssociation>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="VirtoCommerceCatalogModuleWebModelProductAssociation" /> class.
        /// </summary>
        public VirtoCommerceCatalogModuleWebModelProductAssociation()
        {
            
        }

        
        /// <summary>
        /// Gets or sets the ProductAssociation name.
        /// </summary>
        /// <value>Gets or sets the ProductAssociation name.</value>
        [DataMember(Name="name", EmitDefaultValue=false)]
        public string Name { get; set; }
  
        
        /// <summary>
        /// Gets or Sets Description
        /// </summary>
        [DataMember(Name="description", EmitDefaultValue=false)]
        public string Description { get; set; }
  
        
        /// <summary>
        /// Gets or sets the order in which the associated product is displayed.
        /// </summary>
        /// <value>Gets or sets the order in which the associated product is displayed.</value>
        [DataMember(Name="priority", EmitDefaultValue=false)]
        public int? Priority { get; set; }
  
        
        /// <summary>
        /// Gets or sets the identifier of the associated product.
        /// </summary>
        /// <value>Gets or sets the identifier of the associated product.</value>
        [DataMember(Name="productId", EmitDefaultValue=false)]
        public string ProductId { get; set; }
  
        
        /// <summary>
        /// Gets or sets the name of the associated product.
        /// </summary>
        /// <value>Gets or sets the name of the associated product.</value>
        [DataMember(Name="productName", EmitDefaultValue=false)]
        public string ProductName { get; set; }
  
        
        /// <summary>
        /// Gets or sets the associated product code.
        /// </summary>
        /// <value>Gets or sets the associated product code.</value>
        [DataMember(Name="productCode", EmitDefaultValue=false)]
        public string ProductCode { get; set; }
  
        
        /// <summary>
        /// Gets or sets the associated product image.
        /// </summary>
        /// <value>Gets or sets the associated product image.</value>
        [DataMember(Name="productImg", EmitDefaultValue=false)]
        public string ProductImg { get; set; }
  
        
  
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class VirtoCommerceCatalogModuleWebModelProductAssociation {\n");
            sb.Append("  Name: ").Append(Name).Append("\n");
            sb.Append("  Description: ").Append(Description).Append("\n");
            sb.Append("  Priority: ").Append(Priority).Append("\n");
            sb.Append("  ProductId: ").Append(ProductId).Append("\n");
            sb.Append("  ProductName: ").Append(ProductName).Append("\n");
            sb.Append("  ProductCode: ").Append(ProductCode).Append("\n");
            sb.Append("  ProductImg: ").Append(ProductImg).Append("\n");
            
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as VirtoCommerceCatalogModuleWebModelProductAssociation);
        }

        /// <summary>
        /// Returns true if VirtoCommerceCatalogModuleWebModelProductAssociation instances are equal
        /// </summary>
        /// <param name="obj">Instance of VirtoCommerceCatalogModuleWebModelProductAssociation to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(VirtoCommerceCatalogModuleWebModelProductAssociation other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Name == other.Name ||
                    this.Name != null &&
                    this.Name.Equals(other.Name)
                ) && 
                (
                    this.Description == other.Description ||
                    this.Description != null &&
                    this.Description.Equals(other.Description)
                ) && 
                (
                    this.Priority == other.Priority ||
                    this.Priority != null &&
                    this.Priority.Equals(other.Priority)
                ) && 
                (
                    this.ProductId == other.ProductId ||
                    this.ProductId != null &&
                    this.ProductId.Equals(other.ProductId)
                ) && 
                (
                    this.ProductName == other.ProductName ||
                    this.ProductName != null &&
                    this.ProductName.Equals(other.ProductName)
                ) && 
                (
                    this.ProductCode == other.ProductCode ||
                    this.ProductCode != null &&
                    this.ProductCode.Equals(other.ProductCode)
                ) && 
                (
                    this.ProductImg == other.ProductImg ||
                    this.ProductImg != null &&
                    this.ProductImg.Equals(other.ProductImg)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                
                if (this.Name != null)
                    hash = hash * 57 + this.Name.GetHashCode();
                
                if (this.Description != null)
                    hash = hash * 57 + this.Description.GetHashCode();
                
                if (this.Priority != null)
                    hash = hash * 57 + this.Priority.GetHashCode();
                
                if (this.ProductId != null)
                    hash = hash * 57 + this.ProductId.GetHashCode();
                
                if (this.ProductName != null)
                    hash = hash * 57 + this.ProductName.GetHashCode();
                
                if (this.ProductCode != null)
                    hash = hash * 57 + this.ProductCode.GetHashCode();
                
                if (this.ProductImg != null)
                    hash = hash * 57 + this.ProductImg.GetHashCode();
                
                return hash;
            }
        }

    }


}
