using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Newtonsoft.Json;



namespace VirtoCommerce.Client.Model
{

    /// <summary>
    /// 
    /// </summary>
    [DataContract]
    public class VirtoCommerceDomainCommerceModelSeoInfo : IEquatable<VirtoCommerceDomainCommerceModelSeoInfo>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="VirtoCommerceDomainCommerceModelSeoInfo" /> class.
        /// </summary>
        public VirtoCommerceDomainCommerceModelSeoInfo()
        {
            
        }

        
        /// <summary>
        /// Gets or Sets SemanticUrl
        /// </summary>
        [DataMember(Name="semanticUrl", EmitDefaultValue=false)]
        public string SemanticUrl { get; set; }
  
        
        /// <summary>
        /// Gets or Sets PageTitle
        /// </summary>
        [DataMember(Name="pageTitle", EmitDefaultValue=false)]
        public string PageTitle { get; set; }
  
        
        /// <summary>
        /// Gets or Sets MetaDescription
        /// </summary>
        [DataMember(Name="metaDescription", EmitDefaultValue=false)]
        public string MetaDescription { get; set; }
  
        
        /// <summary>
        /// Gets or Sets ImageAltDescription
        /// </summary>
        [DataMember(Name="imageAltDescription", EmitDefaultValue=false)]
        public string ImageAltDescription { get; set; }
  
        
        /// <summary>
        /// Gets or Sets MetaKeywords
        /// </summary>
        [DataMember(Name="metaKeywords", EmitDefaultValue=false)]
        public string MetaKeywords { get; set; }
  
        
        /// <summary>
        /// Gets or Sets ObjectId
        /// </summary>
        [DataMember(Name="objectId", EmitDefaultValue=false)]
        public string ObjectId { get; set; }
  
        
        /// <summary>
        /// Gets or Sets ObjectType
        /// </summary>
        [DataMember(Name="objectType", EmitDefaultValue=false)]
        public string ObjectType { get; set; }
  
        
        /// <summary>
        /// Gets or Sets IsActive
        /// </summary>
        [DataMember(Name="isActive", EmitDefaultValue=false)]
        public bool? IsActive { get; set; }
  
        
        /// <summary>
        /// Gets or Sets LanguageCode
        /// </summary>
        [DataMember(Name="languageCode", EmitDefaultValue=false)]
        public string LanguageCode { get; set; }
  
        
        /// <summary>
        /// Gets or Sets CreatedDate
        /// </summary>
        [DataMember(Name="createdDate", EmitDefaultValue=false)]
        public DateTime? CreatedDate { get; set; }
  
        
        /// <summary>
        /// Gets or Sets ModifiedDate
        /// </summary>
        [DataMember(Name="modifiedDate", EmitDefaultValue=false)]
        public DateTime? ModifiedDate { get; set; }
  
        
        /// <summary>
        /// Gets or Sets CreatedBy
        /// </summary>
        [DataMember(Name="createdBy", EmitDefaultValue=false)]
        public string CreatedBy { get; set; }
  
        
        /// <summary>
        /// Gets or Sets ModifiedBy
        /// </summary>
        [DataMember(Name="modifiedBy", EmitDefaultValue=false)]
        public string ModifiedBy { get; set; }
  
        
        /// <summary>
        /// Gets or Sets Id
        /// </summary>
        [DataMember(Name="id", EmitDefaultValue=false)]
        public string Id { get; set; }
  
        
  
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class VirtoCommerceDomainCommerceModelSeoInfo {\n");
            sb.Append("  SemanticUrl: ").Append(SemanticUrl).Append("\n");
            sb.Append("  PageTitle: ").Append(PageTitle).Append("\n");
            sb.Append("  MetaDescription: ").Append(MetaDescription).Append("\n");
            sb.Append("  ImageAltDescription: ").Append(ImageAltDescription).Append("\n");
            sb.Append("  MetaKeywords: ").Append(MetaKeywords).Append("\n");
            sb.Append("  ObjectId: ").Append(ObjectId).Append("\n");
            sb.Append("  ObjectType: ").Append(ObjectType).Append("\n");
            sb.Append("  IsActive: ").Append(IsActive).Append("\n");
            sb.Append("  LanguageCode: ").Append(LanguageCode).Append("\n");
            sb.Append("  CreatedDate: ").Append(CreatedDate).Append("\n");
            sb.Append("  ModifiedDate: ").Append(ModifiedDate).Append("\n");
            sb.Append("  CreatedBy: ").Append(CreatedBy).Append("\n");
            sb.Append("  ModifiedBy: ").Append(ModifiedBy).Append("\n");
            sb.Append("  Id: ").Append(Id).Append("\n");
            
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as VirtoCommerceDomainCommerceModelSeoInfo);
        }

        /// <summary>
        /// Returns true if VirtoCommerceDomainCommerceModelSeoInfo instances are equal
        /// </summary>
        /// <param name="obj">Instance of VirtoCommerceDomainCommerceModelSeoInfo to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(VirtoCommerceDomainCommerceModelSeoInfo other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.SemanticUrl == other.SemanticUrl ||
                    this.SemanticUrl != null &&
                    this.SemanticUrl.Equals(other.SemanticUrl)
                ) && 
                (
                    this.PageTitle == other.PageTitle ||
                    this.PageTitle != null &&
                    this.PageTitle.Equals(other.PageTitle)
                ) && 
                (
                    this.MetaDescription == other.MetaDescription ||
                    this.MetaDescription != null &&
                    this.MetaDescription.Equals(other.MetaDescription)
                ) && 
                (
                    this.ImageAltDescription == other.ImageAltDescription ||
                    this.ImageAltDescription != null &&
                    this.ImageAltDescription.Equals(other.ImageAltDescription)
                ) && 
                (
                    this.MetaKeywords == other.MetaKeywords ||
                    this.MetaKeywords != null &&
                    this.MetaKeywords.Equals(other.MetaKeywords)
                ) && 
                (
                    this.ObjectId == other.ObjectId ||
                    this.ObjectId != null &&
                    this.ObjectId.Equals(other.ObjectId)
                ) && 
                (
                    this.ObjectType == other.ObjectType ||
                    this.ObjectType != null &&
                    this.ObjectType.Equals(other.ObjectType)
                ) && 
                (
                    this.IsActive == other.IsActive ||
                    this.IsActive != null &&
                    this.IsActive.Equals(other.IsActive)
                ) && 
                (
                    this.LanguageCode == other.LanguageCode ||
                    this.LanguageCode != null &&
                    this.LanguageCode.Equals(other.LanguageCode)
                ) && 
                (
                    this.CreatedDate == other.CreatedDate ||
                    this.CreatedDate != null &&
                    this.CreatedDate.Equals(other.CreatedDate)
                ) && 
                (
                    this.ModifiedDate == other.ModifiedDate ||
                    this.ModifiedDate != null &&
                    this.ModifiedDate.Equals(other.ModifiedDate)
                ) && 
                (
                    this.CreatedBy == other.CreatedBy ||
                    this.CreatedBy != null &&
                    this.CreatedBy.Equals(other.CreatedBy)
                ) && 
                (
                    this.ModifiedBy == other.ModifiedBy ||
                    this.ModifiedBy != null &&
                    this.ModifiedBy.Equals(other.ModifiedBy)
                ) && 
                (
                    this.Id == other.Id ||
                    this.Id != null &&
                    this.Id.Equals(other.Id)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                
                if (this.SemanticUrl != null)
                    hash = hash * 57 + this.SemanticUrl.GetHashCode();
                
                if (this.PageTitle != null)
                    hash = hash * 57 + this.PageTitle.GetHashCode();
                
                if (this.MetaDescription != null)
                    hash = hash * 57 + this.MetaDescription.GetHashCode();
                
                if (this.ImageAltDescription != null)
                    hash = hash * 57 + this.ImageAltDescription.GetHashCode();
                
                if (this.MetaKeywords != null)
                    hash = hash * 57 + this.MetaKeywords.GetHashCode();
                
                if (this.ObjectId != null)
                    hash = hash * 57 + this.ObjectId.GetHashCode();
                
                if (this.ObjectType != null)
                    hash = hash * 57 + this.ObjectType.GetHashCode();
                
                if (this.IsActive != null)
                    hash = hash * 57 + this.IsActive.GetHashCode();
                
                if (this.LanguageCode != null)
                    hash = hash * 57 + this.LanguageCode.GetHashCode();
                
                if (this.CreatedDate != null)
                    hash = hash * 57 + this.CreatedDate.GetHashCode();
                
                if (this.ModifiedDate != null)
                    hash = hash * 57 + this.ModifiedDate.GetHashCode();
                
                if (this.CreatedBy != null)
                    hash = hash * 57 + this.CreatedBy.GetHashCode();
                
                if (this.ModifiedBy != null)
                    hash = hash * 57 + this.ModifiedBy.GetHashCode();
                
                if (this.Id != null)
                    hash = hash * 57 + this.Id.GetHashCode();
                
                return hash;
            }
        }

    }


}
