using System;
using System.Linq;
using System.IO;
using System.Text;
using System.Collections;
using System.Collections.Generic;
using System.Runtime.Serialization;
using Newtonsoft.Json;



namespace VirtoCommerce.Client.Model
{

    /// <summary>
    /// Represent coupon entered by customer on checkout
    /// </summary>
    [DataContract]
    public class VirtoCommerceOrderModuleWebModelCoupon : IEquatable<VirtoCommerceOrderModuleWebModelCoupon>
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="VirtoCommerceOrderModuleWebModelCoupon" /> class.
        /// </summary>
        public VirtoCommerceOrderModuleWebModelCoupon()
        {
            
        }

        
        /// <summary>
        /// Gets or Sets Code
        /// </summary>
        [DataMember(Name="code", EmitDefaultValue=false)]
        public string Code { get; set; }
  
        
        /// <summary>
        /// Gets or Sets InvalidDescription
        /// </summary>
        [DataMember(Name="invalidDescription", EmitDefaultValue=false)]
        public string InvalidDescription { get; set; }
  
        
  
        /// <summary>
        /// Returns the string presentation of the object
        /// </summary>
        /// <returns>String presentation of the object</returns>
        public override string ToString()
        {
            var sb = new StringBuilder();
            sb.Append("class VirtoCommerceOrderModuleWebModelCoupon {\n");
            sb.Append("  Code: ").Append(Code).Append("\n");
            sb.Append("  InvalidDescription: ").Append(InvalidDescription).Append("\n");
            
            sb.Append("}\n");
            return sb.ToString();
        }
  
        /// <summary>
        /// Returns the JSON string presentation of the object
        /// </summary>
        /// <returns>JSON string presentation of the object</returns>
        public string ToJson()
        {
            return JsonConvert.SerializeObject(this, Formatting.Indented);
        }

        /// <summary>
        /// Returns true if objects are equal
        /// </summary>
        /// <param name="obj">Object to be compared</param>
        /// <returns>Boolean</returns>
        public override bool Equals(object obj)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            return this.Equals(obj as VirtoCommerceOrderModuleWebModelCoupon);
        }

        /// <summary>
        /// Returns true if VirtoCommerceOrderModuleWebModelCoupon instances are equal
        /// </summary>
        /// <param name="obj">Instance of VirtoCommerceOrderModuleWebModelCoupon to be compared</param>
        /// <returns>Boolean</returns>
        public bool Equals(VirtoCommerceOrderModuleWebModelCoupon other)
        {
            // credit: http://stackoverflow.com/a/10454552/677735
            if (other == null)
                return false;

            return 
                (
                    this.Code == other.Code ||
                    this.Code != null &&
                    this.Code.Equals(other.Code)
                ) && 
                (
                    this.InvalidDescription == other.InvalidDescription ||
                    this.InvalidDescription != null &&
                    this.InvalidDescription.Equals(other.InvalidDescription)
                );
        }

        /// <summary>
        /// Gets the hash code
        /// </summary>
        /// <returns>Hash code</returns>
        public override int GetHashCode()
        {
            // credit: http://stackoverflow.com/a/263416/677735
            unchecked // Overflow is fine, just wrap
            {
                int hash = 41;
                // Suitable nullity checks etc, of course :)
                
                if (this.Code != null)
                    hash = hash * 57 + this.Code.GetHashCode();
                
                if (this.InvalidDescription != null)
                    hash = hash * 57 + this.InvalidDescription.GetHashCode();
                
                return hash;
            }
        }

    }


}
